<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePicturesTable extends Migration {

	public function up()
	{
		Schema::create('pictures', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('post_id')->unsigned()->nullable();
			$table->string('link', 100);
			$table->enum('type', array('logo', 'avatar', 'post'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pictures');
	}
}