<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('title', 100);
			$table->string('location', 100);
			$table->date('scheduled_at');
			$table->timestamp('last_update');
			$table->enum('type', array('progress', 'archive'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}