<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('email', 'password', 'notifications', 'messages');

    public function devices()
    {
        return $this->hasMany('Device');
    }

    public function packs()
    {
        return $this->belongsTo('Pack', 'Transaction');
    }

    public function features()
    {
        return $this->belongsToMany('Feature', 'UserFeatureLog');
    }

    public function notifications()
    {
        return $this->belongsToMany('Notification');
    }

    public function messages()
    {
        return $this->hasMany('Message');
    }

}