<?php

class Freelancer extends Eloquent {

	protected $table = 'freelancers';
	public $timestamps = false;
	protected $fillable = array('first_name', 'last_name', 'phone', 'image', 'freelancer_curriculum_vitae', 'premium', 'coins');

	public function challenges()
	{
		return $this->belongsToMany('Challenge', 'ChallengeFreelancer');
	}

	public function skills()
	{
		return $this->belongsToMany('Skill', 'FreelancerSkill');
	}

	public function projects()
	{
		return $this->belongsToMany('Project', 'FreelancerProject');
	}

	public function criterions()
	{
		return $this->belongsToMany('Criterion', 'FreelancerCriterionEvaluation');
	}

}