<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Purchase_Order', function(Blueprint $table) {
			$table->foreign('id_Client')->references('id')->on('Clients')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Order_Products', function(Blueprint $table) {
			$table->foreign('id_Products')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Purchase_Order', function(Blueprint $table) {
			$table->dropForeign('Purchase_Order_id_Client_foreign');
		});
		Schema::table('Order_Products', function(Blueprint $table) {
			$table->dropForeign('Order_Products_id_Products_foreign');
		});
	}
}