<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSelectionsTable extends Migration {

	public function up()
	{
		Schema::create('Selections', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 150);
			$table->string('description', 100);
			$table->integer('created_by')->unsigned();
			$table->integer('project_id')->unsigned();
			$table->datetime('deadline')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->date('CourseStartDate')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Selections');
	}
}