<?php

namespace Employees;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employees extends Model 
{

    protected $table = 'employees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function employeeHasManyPayroll()
    {
        return $this->hasMany('Payroll', 'employee_id');
    }

    public function employeeHasManyFamily()
    {
        return $this->hasMany('Applicants', 'employee_id');
    }

    public function employeeHasManyFamily()
    {
        return $this->hasMany('Families', 'employee_id');
    }

    public function employeeHasManyAttendance()
    {
        return $this->hasMany('Attendance', 'employee_id');
    }

}