<?php

namespace Recruitment;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Applicants extends Model 
{

    protected $table = 'applicants';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function ApplicantstHasManyStatuses()
    {
        return $this->hasMany('Statuses', 'id_applicant');
    }

    public function ApplicantsHasManyJobRecords()
    {
        return $this->hasMany('JobRecords', 'id_applicant');
    }

    public function ApplicantsHasManyDebitorRecords()
    {
        return $this->hasMany('DebitorRecords', 'id_applicant');
    }

    public function ApplicantsHasManyEducations()
    {
        return $this->hasMany('Educations', 'id_applicant');
    }

    public function ApplicantsHasManyFamilies()
    {
        return $this->hasMany('Families', 'id_applicant');
    }

}