<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('serial')->nullable();
			$table->integer('category_id')->nullable();
			$table->string('barcode')->nullable();
			$table->integer('amount')->nullable();
			$table->double('buy_price')->nullable();
			$table->boolean('sellable')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}