<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorTable extends Migration {

	public function up()
	{
		Schema::create('vendor', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('mall_id')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->string('company_name_en')->nullable();
			$table->string('company_name_ar')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->string('address_en')->nullable();
			$table->string('address_ar')->nullable();
			$table->double('balance')->nullable();
			$table->string('tax_number')->nullable();
			$table->enum('status', array('active', 'inactive'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('vendor');
	}
}