<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeTable extends Migration {

	public function up()
	{
		Schema::create('employee', function(Blueprint $table) {
			$table->increments('employee_id', true);
			$table->timestamps();
			$table->string('firstname', 255);
			$table->string('lastname', 255);
			$table->string('dni', 255);
			$table->string('payroll', 255);
			$table->string('costCenter', 255);
			$table->string('adminPosition', 255);
			$table->integer('enterpriseheadquarter_id')->unsigned();
			$table->boolean('status')->default(true);
			$table->integer('enterprise_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('employee');
	}
}