<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssistanceTable extends Migration {

	public function up()
	{
		Schema::create('assistance', function(Blueprint $table) {
			$table->increments('assistance_id', true);
			$table->timestamps();
			$table->boolean('isMissing')->nullable();
			$table->string('missingReason', 255);
			$table->boolean('isLate');
			$table->string('lateReason', 255);
			$table->datetime('tiempoEntroTarde');
			$table->datetime('tiempoSalioAntes');
			$table->integer('turnemployee_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('assistance');
	}
}