<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Activity extends Model 
{

    protected $table = 'activity';
    public $timestamps = true;
    protected $guarded = array('activity_id', 'timestamps');
    protected $fillable = array('title', 'description', 'expectedProductivity', 'kpi', 'measurementUnit', 'manHours', 'status');

    public function getTurnActivities()
    {
        return $this->hasMany('App\TurnActivity', 'activity_id');
    }

    public function getActivityEmployee()
    {
        return $this->hasMany('App\ActivityEmployee', 'activity_id');
    }

}