<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderAddressesTable extends Migration {

	public function up()
	{
		Schema::create('order_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->enum('type', array('billing', 'shipping'));
			$table->string('email');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('company_name');
			$table->string('country');
			$table->string('city');
			$table->string('code');
			$table->string('phone');
			$table->smallInteger('house');
			$table->text('information');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_addresses');
	}
}