<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('request_id')->unsigned();
			$table->string('method');
			$table->string('type');
			$table->string('payment_id');
			$table->string('transaction_id');
			$table->date('post_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}