<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('consultants', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('consultant_id')->references('id')->on('consultants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('consultant_scedule_id')->references('id')->on('consultant_scedules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emergancy_requests', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emergancy_requests', function(Blueprint $table) {
			$table->foreign('request_id')->references('id')->on('requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultant_scedules', function(Blueprint $table) {
			$table->foreign('consultant_id')->references('id')->on('consultants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('request_id')->references('id')->on('requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('consultants', function(Blueprint $table) {
			$table->dropForeign('consultants_category_id_foreign');
		});
		Schema::table('consultants', function(Blueprint $table) {
			$table->dropForeign('consultants_user_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_user_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_consultant_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_consultant_scedule_id_foreign');
		});
		Schema::table('emergancy_requests', function(Blueprint $table) {
			$table->dropForeign('emergancy_requests_category_id_foreign');
		});
		Schema::table('emergancy_requests', function(Blueprint $table) {
			$table->dropForeign('emergancy_requests_request_id_foreign');
		});
		Schema::table('consultant_scedules', function(Blueprint $table) {
			$table->dropForeign('consultant_scedules_consultant_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_request_id_foreign');
		});
	}
}