<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('consultant_id')->unsigned();
			$table->enum('status', array('pending', 'accepted', 'rejected'));
			$table->integer('consultant_scedule_id')->unsigned()->nullable();
			$table->integer('period')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}