<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('Customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email', 64)->unique();
			$table->string('billing_address')->nullable();
			$table->string('billing_postcode')->nullable();
			$table->string('billing_address2')->nullable();
			$table->string('billing_phone')->nullable();
			$table->boolean('isTeacher')->default(false);
			$table->boolean('isStudent')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('Customers');
	}
}