<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_review', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wallet_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Codes', function(Blueprint $table) {
			$table->foreign('shipment_company_id')->references('id')->on('shipment_Companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
		Schema::table('product_review', function(Blueprint $table) {
			$table->dropForeign('product_review_product_id_foreign');
		});
		Schema::table('wallet_details', function(Blueprint $table) {
			$table->dropForeign('wallet_details_user_id_foreign');
		});
		Schema::table('Codes', function(Blueprint $table) {
			$table->dropForeign('Codes_shipment_company_id_foreign');
		});
	}
}