<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name_en');
			$table->string('name_ar');
			$table->text('description_en');
			$table->text('description_ar');
			$table->text('content_en');
			$table->text('content_ar');
			$table->tinyInteger('status')->default('1');
			$table->string('image');
			$table->boolean('home')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}