<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'phone', 'avatar', 'disabled');
    protected $visible = array('name', 'phone', 'avatar', 'disabled');

    public function orders()
    {
        return $this->hasMany('Order');
    }

    public function locations()
    {
        return $this->hasMany('Location');
    }

}