<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('status_id');
			$table->integer('company_id');
			$table->integer('project_id');
			$table->tinyInteger('type_id');
			$table->integer('priority_id')->nullable();
			$table->string('name', 191);
			$table->text('detail')->nullable();
			$table->timestamp('start_time')->nullable();
			$table->timestamp('finish_time')->nullable();
			$table->time('working_hours');
			$table->text('problem_reason')->nullable();
			$table->text('problem_solution');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}