<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Contract extends Eloquent {

	protected $table = 'contracts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('company_id', 'project_id', 'type_id', 'start_date', 'finish_date', 'working_hours');
	protected $visible = array('company_id', 'project_id', 'type_id', 'start_date', 'finish_date', 'working_hours');

	public function company()
	{
		return $this->belongsTo('Company');
	}

	public function project()
	{
		return $this->belongsTo('Project');
	}

	public function type()
	{
		return $this->hasOne('ContractType');
	}

}