<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('company_id', 'role_id', 'username', 'name', 'email', 'password', 'remember_token');
	protected $visible = array('company_id', 'role_id', 'username', 'name', 'email', 'password', 'remember_token');

	public function comments()
	{
		return $this->hasMany('Comment');
	}

	public function tasks()
	{
		return $this->belongsToMany('Ticket', 'user_tickets', 'user_id', 'ticket_id');
	}

	public function role()
	{
		return $this->belongsTo('Role');
	}

}