<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAlertsTable extends Migration {

	public function up()
	{
		Schema::create('alerts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->integer('owner_user_id')->unsigned();
			$table->integer('milestone_id')->unsigned()->nullable();
			$table->integer('payment_id')->unsigned()->nullable();
			$table->integer('modify_id')->unsigned()->nullable();
			$table->integer('monitoring_id')->unsigned()->nullable();
			$table->integer('procurement_id')->unsigned()->nullable();
			$table->integer('statement_id')->unsigned()->nullable();
			$table->string('name');
			$table->text('remark')->nullable();
			$table->enum('type', array('milestone', 'payment', 'modify', 'monitoring', 'procurement', 'statement'));
			$table->date('close_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('alerts');
	}
}