<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMilestonesTable extends Migration {

	public function up()
	{
		Schema::create('milestones', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->integer('project_status_id')->unsigned();
			$table->integer('milestone_status_id')->unsigned();
			$table->integer('owner_user_id')->unsigned();
			$table->string('name');
			$table->text('remark')->nullable();
			$table->date('planned_end_date');
			$table->date('end_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('milestones');
	}
}