<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->integer('project_status_id')->unsigned();
			$table->integer('payment_status_id')->unsigned();
			$table->integer('payment_type_id')->unsigned();
			$table->integer('owner_user_id')->unsigned();
			$table->integer('milestone_id')->unsigned();
			$table->string('name');
			$table->text('remark')->nullable();
			$table->date('planned_payment_date');
			$table->date('payment_date')->nullable();
			$table->boolean('max_amount');
			$table->bigInteger('requested_amount')->unsigned();
			$table->bigInteger('accepted_amount')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}