<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHistoryTable extends Migration {

	public function up()
	{
		Schema::create('history', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('old_project_status_id')->unsigned()->nullable();
			$table->integer('new_project_status_id')->unsigned()->nullable();
			$table->text('remark')->nullable();
			$table->integer('old_sub_status_id')->unsigned()->nullable();
			$table->integer('new_sub_status_id')->unsigned()->nullable();
			$table->date('change_date')->nullable();
			$table->integer('milestone_id')->unsigned()->nullable();
			$table->integer('old_milestone_status_id')->unsigned()->nullable();
			$table->integer('new_milestone_status_id')->unsigned()->nullable();
			$table->integer('payment_id')->unsigned()->nullable();
			$table->integer('old_payment_status_id')->unsigned()->nullable();
			$table->integer('new_payment_status_id')->unsigned()->nullable();
			$table->integer('modify_id')->unsigned()->nullable();
			$table->integer('old_modify_status_id')->unsigned()->nullable();
			$table->integer('new_modify_status_id')->unsigned()->nullable();
			$table->integer('monitoring_id')->unsigned()->nullable();
			$table->integer('old_monitoring_status_id')->unsigned()->nullable();
			$table->integer('new_monitoring_status_id')->unsigned()->nullable();
			$table->integer('procurement_id')->unsigned()->nullable();
			$table->integer('old_procurement_status_id')->unsigned()->nullable();
			$table->integer('new_procurement_status_id')->unsigned()->nullable();
			$table->integer('statement_id')->unsigned()->nullable();
			$table->integer('old_statement_status_id')->unsigned()->nullable();
			$table->integer('new_statement_status_id')->unsigned()->nullable();
			$table->enum('type', array('project', 'milestone', 'payment', 'modify', 'monitoring', 'procurement', 'statement'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('history');
	}
}