<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Financing extends Eloquent {

	protected $table = 'financings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function projects()
	{
		return $this->belongsToMany('App\Models\Project', 'project_financing', 'financing_id', 'project_id');
	}

}