<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Partner extends Eloquent {

	protected $table = 'partners';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function projects()
	{
		return $this->belongsToMany('App\Models\Project', 'project_partner', 'partner_id', 'project_id');
	}

}