<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModifiesTable extends Migration {

	public function up()
	{
		Schema::create('modifies', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->integer('project_status_id')->unsigned();
			$table->integer('modify_status_id')->unsigned();
			$table->integer('modify_type_id')->unsigned();
			$table->integer('owner_user_id')->unsigned();
			$table->integer('payment_id')->unsigned();
			$table->string('name');
			$table->text('remark')->nullable();
			$table->date('effective_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('modifies');
	}
}