<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatementsTable extends Migration {

	public function up()
	{
		Schema::create('statements', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->integer('statement_status_id')->unsigned();
			$table->integer('statement_type_id')->unsigned();
			$table->integer('owner_user_id')->unsigned();
			$table->string('name');
			$table->text('remark')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('statements');
	}
}