<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Family extends Model 
{

    protected $table = 'family';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('student1', 'student2', 'relation');

    public function student1()
    {
        return $this->belongsTo('App\Student', 'student1');
    }

    public function student2()
    {
        return $this->hasOne('App\Student', 'student2');
    }

}