<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentTable extends Migration {

	public function up()
	{
		Schema::create('student', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('fname', 255);
			$table->string('lname', 255);
			$table->enum('gender', array('Male', 'Female'));
			$table->text('image');
			$table->date('date_of_birth');
			$table->enum('religion', array('Buddhism', 'Hinduism', 'Islam', 'Christianity', 'Other/None'));
			$table->enum('blood_group', array('O-positive', 'O-negative', 'A-positive', 'A-negative', 'B-positive', 'B-negative', 'AB-positive', 'AB-negative'));
			$table->string('mobile')->nullable();
			$table->string('email')->nullable();
			$table->integer('guardian_id')->unsigned();
			$table->integer('address_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
			$table->string('admission_id', 255);
		});
	}

	public function down()
	{
		Schema::drop('student');
	}
}