<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('schedule_id')->unsigned();
			$table->longText('notes')->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('astrologer_id')->unsigned();
			$table->string('service');
			$table->datetime('scheduled_at');
			$table->datetime('start_at');
			$table->datetime('end_at');
			$table->string('status');
			$table->decimal('charge');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}