<?php

namespace FormsEmail;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormsEmail extends Model 
{

    protected $table = 'forms_email';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('form_id', 'email_name', 'email_address');
    protected $visible = array('email_name', 'email_address');

    public function Forms()
    {
        return $this->hasOne('Forms', 'id');
    }

}