<?php

namespace FormsData;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FormsData extends Eloquent {

	protected $table = 'forms_data';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('message_id', 'input_id');

	public function message()
	{
		return $this->belongsTo('FormsMessages', 'form_id');
	}

	public function inputs()
	{
		return $this->belongsTo('FormsInput', 'id');
	}

}