<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('fk_catid')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('fk_product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('fk_userid')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('fk_orderid')->references('id')->on('order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_fk_catid_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_fk_product_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_fk_userid_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_fk_orderid_foreign');
		});
	}
}