<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('departmentnumber', function(Blueprint $table) {
			$table->foreign('businesscategory_id')->references('id')->on('businesscategory')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ldap_attribute_profile_rights', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ldap_attribute_profile_rights', function(Blueprint $table) {
			$table->foreign('ldap_attribute_id')->references('id')->on('ldap_attributes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('operational_profile_rights', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('operational_profile_rights', function(Blueprint $table) {
			$table->foreign('account_type_id')->references('id')->on('account_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profile_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profile_user', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ldap_attribute_user_rights', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ldap_attribute_user_rights', function(Blueprint $table) {
			$table->foreign('ldap_attribute_id')->references('id')->on('ldap_attributes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('operational_user_rights', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('operational_user_rights', function(Blueprint $table) {
			$table->foreign('account_type_id')->references('id')->on('account_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->foreign('ldap_attribute_id')->references('id')->on('ldap_attributes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->foreign('account_type_id')->references('id')->on('account_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lease_values', function(Blueprint $table) {
			$table->foreign('lease_id')->references('id')->on('leases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lease_values', function(Blueprint $table) {
			$table->foreign('ldap_attribute_id')->references('id')->on('ldap_attributes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('departmentnumber', function(Blueprint $table) {
			$table->dropForeign('departmentnumber_businesscategory_id_foreign');
		});
		Schema::table('ldap_attribute_profile_rights', function(Blueprint $table) {
			$table->dropForeign('ldap_attribute_profile_rights_profile_id_foreign');
		});
		Schema::table('ldap_attribute_profile_rights', function(Blueprint $table) {
			$table->dropForeign('ldap_attribute_profile_rights_ldap_attribute_id_foreign');
		});
		Schema::table('operational_profile_rights', function(Blueprint $table) {
			$table->dropForeign('operational_profile_rights_profile_id_foreign');
		});
		Schema::table('operational_profile_rights', function(Blueprint $table) {
			$table->dropForeign('operational_profile_rights_account_type_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_user_id_foreign');
		});
		Schema::table('profile_user', function(Blueprint $table) {
			$table->dropForeign('profile_user_user_id_foreign');
		});
		Schema::table('profile_user', function(Blueprint $table) {
			$table->dropForeign('profile_user_profile_id_foreign');
		});
		Schema::table('ldap_attribute_user_rights', function(Blueprint $table) {
			$table->dropForeign('ldap_attribute_user_rights_user_id_foreign');
		});
		Schema::table('ldap_attribute_user_rights', function(Blueprint $table) {
			$table->dropForeign('ldap_attribute_user_rights_ldap_attribute_id_foreign');
		});
		Schema::table('operational_user_rights', function(Blueprint $table) {
			$table->dropForeign('operational_user_rights_user_id_foreign');
		});
		Schema::table('operational_user_rights', function(Blueprint $table) {
			$table->dropForeign('operational_user_rights_account_type_id_foreign');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->dropForeign('requirements_ldap_attribute_id_foreign');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->dropForeign('requirements_account_type_id_foreign');
		});
		Schema::table('lease_values', function(Blueprint $table) {
			$table->dropForeign('lease_values_lease_id_foreign');
		});
		Schema::table('lease_values', function(Blueprint $table) {
			$table->dropForeign('lease_values_ldap_attribute_id_foreign');
		});
	}
}