<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('first_name');

    public function userProfiles()
    {
        return $this->hasMany('Profile');
    }

    public function ldapRights()
    {
        return $this->hasMany('LdapAttributeUserRight');
    }

    public function operationalRights()
    {
        return $this->hasMany('OperationalUserRight');
    }

    public function accounts()
    {
        return $this->hasMany('Account');
    }

}