<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCareersTable extends Migration {

	public function up()
	{
		Schema::create('careers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('career_name', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->string('vacancies')->nullable();
			$table->date('end_date')->nullable();
			$table->text('pdf_upload')->nullable();
			$table->string('is_active', 255)->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('careers');
	}
}