<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('applications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->foreign('career_id')->references('id')->on('careers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('applications', function(Blueprint $table) {
			$table->dropForeign('applications_user_id_foreign');
		});
		Schema::table('applications', function(Blueprint $table) {
			$table->dropForeign('applications_career_id_foreign');
		});
	}
}