<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTransactionTable extends Migration {

	public function up()
	{
		Schema::create('order_transaction', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id')->unsigned()->nullable();
			$table->string('payment_id')->nullable();
			$table->string('transaction_number')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->string('currency')->nullable();
			$table->integer('total');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_transaction');
	}
}