<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBreakoutsTable extends Migration {

	public function up()
	{
		Schema::create('breakouts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->text('description')->nullable();
			$table->integer('invitee_limit')->unsigned()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('breakouts');
	}
}