<?php

namespace ReplyLive\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Breakout extends Eloquent {

	protected $table = 'breakouts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'description', 'invitee_limit');

	public function activity()
	{
		return $this->belongsTo('Activity', 'activity_id');
	}

	public function location()
	{
		return $this->belongsTo('Location');
	}

	public function speaker()
	{
		return $this->hasOne('Speaker', 'speaker_id');
	}

	public function appNotification()
	{
		return $this->hasOne('AppNotification');
	}

}