<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function access_tokens()
	{
		return $this->morphMany('App\AccessToken', 'tokenable');
	}

	public function likesToUsers()
	{
		return $this->belongsToMany('UserLike');
	}

	public function dislikesToUser()
	{
		return $this->belongsToMany('UserDislike');
	}

	public function interests()
	{
		return $this->belongsToMany('UserInterest');
	}

	public function participant()
	{
		return $this->belongsToMany('Participant');
	}

	public function rewards()
	{
		return $this->belongsToMany('UserRewards');
	}

}