<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('leerling', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leerling', function(Blueprint $table) {
			$table->foreign('klas_id')->references('id')->on('klas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('klas', function(Blueprint $table) {
			$table->foreign('richting_id')->references('id')->on('richting')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesopdracht', function(Blueprint $table) {
			$table->foreign('vak_id')->references('id')->on('vak')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesopdracht', function(Blueprint $table) {
			$table->foreign('groep_id')->references('id')->on('groep')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leerkracht', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('toetsenlijst', function(Blueprint $table) {
			$table->foreign('toetsenlijst-type_id')->references('id')->on('toetsenlijst-type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('toetsenlijst', function(Blueprint $table) {
			$table->foreign('lesopdracht_id')->references('id')->on('lesopdracht')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('toets', function(Blueprint $table) {
			$table->foreign('toetsenlijst_id')->references('id')->on('toetsenlijst')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cijfer', function(Blueprint $table) {
			$table->foreign('toets_id')->references('id')->on('toets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cijfer', function(Blueprint $table) {
			$table->foreign('leerling_id')->references('id')->on('leerling')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trimverhouding', function(Blueprint $table) {
			$table->foreign('richting_id')->references('id')->on('richting')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trimverhouding', function(Blueprint $table) {
			$table->foreign('toetsenlijst-type_id')->references('id')->on('toetsenlijst-type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('leerling', function(Blueprint $table) {
			$table->dropForeign('leerling_user_id_foreign');
		});
		Schema::table('leerling', function(Blueprint $table) {
			$table->dropForeign('leerling_klas_id_foreign');
		});
		Schema::table('klas', function(Blueprint $table) {
			$table->dropForeign('klas_richting_id_foreign');
		});
		Schema::table('lesopdracht', function(Blueprint $table) {
			$table->dropForeign('lesopdracht_vak_id_foreign');
		});
		Schema::table('lesopdracht', function(Blueprint $table) {
			$table->dropForeign('lesopdracht_groep_id_foreign');
		});
		Schema::table('leerkracht', function(Blueprint $table) {
			$table->dropForeign('leerkracht_user_id_foreign');
		});
		Schema::table('toetsenlijst', function(Blueprint $table) {
			$table->dropForeign('toetsenlijst_toetsenlijst-type_id_foreign');
		});
		Schema::table('toetsenlijst', function(Blueprint $table) {
			$table->dropForeign('toetsenlijst_lesopdracht_id_foreign');
		});
		Schema::table('toets', function(Blueprint $table) {
			$table->dropForeign('toets_toetsenlijst_id_foreign');
		});
		Schema::table('cijfer', function(Blueprint $table) {
			$table->dropForeign('cijfer_toets_id_foreign');
		});
		Schema::table('cijfer', function(Blueprint $table) {
			$table->dropForeign('cijfer_leerling_id_foreign');
		});
		Schema::table('trimverhouding', function(Blueprint $table) {
			$table->dropForeign('trimverhouding_richting_id_foreign');
		});
		Schema::table('trimverhouding', function(Blueprint $table) {
			$table->dropForeign('trimverhouding_toetsenlijst-type_id_foreign');
		});
	}
}