<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('traffic_source_id')->references('id')->on('traffic_sources')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('offer_template_properties', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('campaign_offer', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('campaign_offer', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('application_offer', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('application_offer', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('traffic_source_trackings', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('traffic_source_trackings', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('traffic_source_trackings', function(Blueprint $table) {
			$table->foreign('traffic_source_id')->references('id')->on('traffic_sources')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_traffic_source_id_foreign');
		});
		Schema::table('offer_template_properties', function(Blueprint $table) {
			$table->dropForeign('offer_template_properties_offer_id_foreign');
		});
		Schema::table('campaign_offer', function(Blueprint $table) {
			$table->dropForeign('campaign_offer_campaign_id_foreign');
		});
		Schema::table('campaign_offer', function(Blueprint $table) {
			$table->dropForeign('campaign_offer_offer_id_foreign');
		});
		Schema::table('application_offer', function(Blueprint $table) {
			$table->dropForeign('application_offer_application_id_foreign');
		});
		Schema::table('application_offer', function(Blueprint $table) {
			$table->dropForeign('application_offer_offer_id_foreign');
		});
		Schema::table('traffic_source_trackings', function(Blueprint $table) {
			$table->dropForeign('traffic_source_trackings_campaign_id_foreign');
		});
		Schema::table('traffic_source_trackings', function(Blueprint $table) {
			$table->dropForeign('traffic_source_trackings_offer_id_foreign');
		});
		Schema::table('traffic_source_trackings', function(Blueprint $table) {
			$table->dropForeign('traffic_source_trackings_traffic_source_id_foreign');
		});
	}
}