<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Galerie extends Eloquent {

	protected $table = 'galeries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_bien', 'photo');
	protected $visible = array('slug', 'id_bien', 'photo');

	public function bien()
	{
		return $this->belongsTo('App\Bien', 'id_bien');
	}

}