<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MotifTransaction extends Eloquent {

	protected $table = 'motifTransactions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'libelle');
	protected $visible = array('slug', 'libelle');

	public function transaction()
	{
		return $this->hasMany('App\Transaction', 'id_motifTransaction');
	}

}